-- Adjust this setting to control where the objects get created.
SET search_path = public;

BEGIN;

CREATE FUNCTION pg_reloption(options text[], var text, conf text) RETURNS text AS
$$
SELECT i[2] AS r FROM (SELECT regexp_split_to_array(opt, '=') AS i
  FROM unnest($1) AS opt) t WHERE i[1] = $2
UNION ALL SELECT current_setting($3) LIMIT 1
$$
LANGUAGE sql STABLE;

CREATE FUNCTION pg_reloption(options text[], var text) RETURNS text AS
$$SELECT pg_reloption($1, $2, $2)$$
LANGUAGE sql STABLE;

CREATE VIEW pg_vacuum_demand AS
SELECT quote_ident(nspname) || '.' || quote_ident(c.relname) AS relname,
       c.oid AS relid,
       c.reltuples AS tuples,
       pg_stat_get_dead_tuples(c.oid) AS dead_tuples,
       pg_reloption(c.reloptions, 'autovacuum_vacuum_threshold')::int4 AS threshold,
       pg_reloption(c.reloptions, 'autovacuum_vacuum_scale_factor')::float8 AS scale_factor,
       age(c.relfrozenxid) AS age,
       pg_reloption(c.reloptions, 'autovacuum_freeze_max_age')::int4 AS max_age,
       t.oid AS t_relid,
       coalesce(t.reltuples, 0) AS t_tuples,
       pg_stat_get_dead_tuples(t.oid) AS t_dead_tuples,
       pg_reloption(t.reloptions, 'autovacuum_vacuum_threshold')::int4 AS t_threshold,
       pg_reloption(t.reloptions, 'autovacuum_vacuum_scale_factor')::float8 AS t_scale_factor,
       age(t.relfrozenxid) AS t_age,
       pg_reloption(t.reloptions, 'autovacuum_freeze_max_age')::int4 AS t_max_age
  FROM pg_class c LEFT JOIN pg_class t ON c.reltoastrelid = t.oid,
       pg_namespace n
 WHERE c.relkind = 'r'
   AND c.relnamespace = n.oid;

CREATE FUNCTION pg_vacuum_jobs(
    scale float8,
    OUT relid oid,
    OUT query text,
    OUT dead_tuples float8,
    OUT age float8)
RETURNS SETOF record AS
$$
SELECT relid, 'VACUUM VERBOSE ' || relname,
       greatest(0.0,
         dead_tuples - (threshold * $1 + scale_factor * $1 * tuples),
         t_dead_tuples - (t_threshold * $1 + t_scale_factor * $1 * t_tuples))
       / greatest(1.0, tuples, t_tuples),
       greatest(0.0, age - max_age * $1, t_age - t_max_age * $1)
       / greatest(1.0, max_age, t_max_age)
  FROM pg_vacuum_demand
$$
LANGUAGE sql STABLE STRICT;

COMMIT;
