/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util.regexp;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.regexp.Regexp;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class RegexpFactory
extends RegexpMatcherFactory {
    public Regexp newRegexp() throws BuildException {
        return this.newRegexp(null);
    }

    public Regexp newRegexp(Project p) throws BuildException {
        String systemDefault = null;
        systemDefault = p == null ? System.getProperty("ant.regexp.regexpimpl") : p.getProperty("ant.regexp.regexpimpl");
        if (systemDefault != null) {
            return this.createRegexpInstance(systemDefault);
        }
        try {
            return this.createRegexpInstance("org.apache.tools.ant.util.regexp.Jdk14RegexpRegexp");
        }
        catch (BuildException be) {
            try {
                return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaOroRegexp");
            }
            catch (BuildException be2) {
                try {
                    return this.createRegexpInstance("org.apache.tools.ant.util.regexp.JakartaRegexpRegexp");
                }
                catch (BuildException buildException) {
                    throw new BuildException("No supported regular expression matcher found");
                }
            }
        }
    }

    protected Regexp createRegexpInstance(String classname) throws BuildException {
        RegexpMatcher m = this.createInstance(classname);
        if (m instanceof Regexp) {
            return (Regexp)m;
        }
        throw new BuildException(classname + " doesn't implement the Regexp interface");
    }
}

