/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef VIEWGROUPITEMPOPUP_H
#define VIEWGROUPITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "viewgrouplistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a view group item in the list viewer.
 */
class ViewGroupItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	ViewGroupListViewItem * m_poViewGroupItem;	
	
public:
	/**
	 * Constructor
	 */
	ViewGroupItemPopup(QWidget *pqoParent, ViewGroupListViewItem *poViewGroupItem);

	/**
	 * Used to access the view group list view item.
	 */
	ViewGroupListViewItem * getViewGroupListViewItem() const;
	
protected slots:	
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the view list.
   */	
	void refreshListOfViews();
		
};


#endif

